/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.UnsupportedEncodingException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBaseVariable;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;

public abstract class DBGpValue
extends DBGpElement
implements IValue {
    private boolean modifiable = false;
    private IVariable[] variables = new IVariable[0];
    private DBGpBaseVariable owner;
    private String valueString = "";
    private byte[] valueBytes = null;
    private static final String ENCODING_BASE64 = "base64";

    public byte[] getValueBytes() {
        return this.valueBytes;
    }

    public void setValueBytes(byte[] valueBytes) {
        this.valueBytes = valueBytes;
    }

    public DBGpValue(DBGpBaseVariable variable) {
        super(variable.getDebugTarget());
        this.owner = variable;
    }

    public DBGpValue(DBGpBaseVariable variable, Node property) {
        super(variable.getDebugTarget());
        this.owner = variable;
        this.simpleParseNode(property);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    boolean isModifiable() {
        return this.modifiable;
    }

    void setModifiable(boolean canModify) {
        this.modifiable = canModify;
    }

    public abstract String getReferenceTypeName() throws DebugException;

    public String getValueString() throws DebugException {
        return this.valueString;
    }

    void setValueString(String newValueStr) {
        this.valueString = newValueStr;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
    }

    public DBGpBaseVariable getOwner() {
        return this.owner;
    }

    void simpleParseNode(Node property) {
        String data = null;
        String encoding = DBGpResponse.getAttribute(property, "encoding");
        Node Child = property.getFirstChild();
        if (Child != null) {
            data = this.decodeValue(Child.getNodeValue(), encoding);
        }
        this.genValueString(data);
    }

    private String decodeValue(String valueData, String encoding) {
        String resStr = valueData;
        if (encoding != null && encoding.equalsIgnoreCase(ENCODING_BASE64) && valueData != null && valueData.trim().length() != 0) {
            DBGpTarget target = (DBGpTarget)this.getDebugTarget();
            this.valueBytes = Base64.decode(valueData.trim());
            try {
                resStr = new String(this.valueBytes, target.getBinaryEncoding());
            }
            catch (UnsupportedEncodingException e) {
                DBGpLogger.logException("unexpected encoding problem", (Object)this, e);
                resStr = new String(this.valueBytes);
            }
        }
        return resStr;
    }

    abstract void genValueString(String var1);
}

